//=============================================================================
// AmmoShell.
//=============================================================================
class MSBorderlandsSummonMutator extends Mutator;

var bool bChallengeMode;
var MSBorderlandsMutator Mutator;


var float LastDamage, LastBuild; //shield variables!

function PostBeginPlay()
{   
	Level.Game.BaseMutator.AddMutator(Self);
	Level.Game.RegisterDamageMutator(Self);
}

simulated function ShowMessage(DeusExPlayer Player, string Message)
{
  local HUDMissionStartTextDisplay    HUD;

  if ((Player.RootWindow != None) && (DeusExRootWindow(Player.RootWindow).HUD != None))
  {
    HUD = DeusExRootWindow(Player.RootWindow).HUD.startDisplay;
  }
  if(HUD != None)
  {
    HUD.shadowDist = 0;
    HUD.Message = "";
    HUD.charIndex = 0;
    HUD.winText.SetText("");
    HUD.winTextShadow.SetText("");
    HUD.displayTime = 5.50;
    HUD.perCharDelay = 0.30;
    HUD.AddMessage(Message);
    HUD.StartMessage();
  }
}

function Mutate(string S, PlayerPawn P)
{
 local DeusExMPGame A;
 local int i, j;
 local string STrim;
 
 if (S ~= "ChallengeMode")
 {
  if (!bChallengeMode)
  {
   ShowMessage(DeusExPlayer(P), "|p4Are You Sure You Want To Start Challenge Mode? Y/N");
   bChallengeMode = True;
  }
 }
 if (S ~= "N" || S ~= "No" || S ~= "ChallengeMode N" || S ~= "ChallengeMode No")
 {
  bChallengeMode = False;
 }
 if (S ~= "Y" || S ~= "Yes" || S ~= "ChallengeMode Y" || S ~= "ChallengeMode Yes")
 {
  if (bChallengeMode) StartChallengeMode(DeusExPlayer(P));
 }
 if (S ~= "BootWindow")
 {
  Mutator.SpawnTargetWindow();
 }
 if (S ~= "CrashWindow")
 {
  Mutator.HideTargetWindow();
 }
 if (S ~= "ToggleFrob")
 {
  Mutator.ToggleFrobDisplay();
 }
 if (S ~= "LevelProgress" || S ~= "Level" || S ~= "Progress" || S ~= "PlayerLevel")
 {
  ShowMessage(  DeusExPlayer(P), "|ca128f0Level: |p4"$Mutator.CurrentLevel$" |ca128f0XP:|p4"$Mutator.CurXP$"|p1/|p4"$Mutator.XPNeeded  );
 }
 if (S ~= "BonusArea" || S ~= "Bonus" || S ~= "WepCamp")
 {
  if (FirstLevel().MapName ~= "WepCamp") P.ClientTravel(FirstMutator().LastMapName, TRAVEL_Relative, True);
  if (FirstLevel().MapName != "WepCamp") P.ClientTravel("WepCamp", TRAVEL_Relative, True);
 }
 
 Super.Mutate(S, P);
}


function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn Inst, out Vector H, out Vector M, name DamageType)
{
 local DeusExPlayer V;
 
 /*if (Victim.IsA('ScriptedPawn') && Inst.IsA('DeusExPlayer') && Victim.Health > 0 && Mutator.Target != Victim)
 {
  Mutator.SetTarget( ScriptedPawn(Victim) );
 }*/

 if (Victim.IsA('DeusExPlayer') && ActualDamage > 0)
 {
  V = DeusExPlayer(Victim);
  
  if (V.Energy > 0)
  {
   LastDamage = 5.0;
   
   if (DamageType == 'Shocked' || DamageType == 'EMP')
   {
    V.Energy -= ActualDamage * 2 * ((V.CombatDifficulty + 1) / 2);
   }
   if (DamageType == 'Flamed' || DamageType == 'Burned')
   {
    V.Energy -= ActualDamage / 2 * ((V.CombatDifficulty + 1) / 2);
   }
   else
   {
    V.Energy -= ActualDamage * ((V.CombatDifficulty + 1) / 2);
   }
   
   V.ClientFlash( 0.01, vect(0,0,50) );
   ActualDamage = 0;
  }
  if (V.Energy <= 0)
  {
   V.ClientFlash( 0.01, vect(50,0,0) );
  }
 }
 
 Super.MutatorTakeDamage(ActualDamage, Victim, Inst, H, M, DamageType);
}

function DeusExPlayer FirstPlayer()
{
 local DeusExPlayer Play;
 
 forEach allActors(class'DeusExPlayer', Play)
 {
  return Play;
 }
}
function MSBorderlandsMutator FirstMutator()
{
 local MSBorderlandsMutator M;
 
 forEach allActors(class'MSBorderlandsMutator', M)
 {
  return M;
 }
}
function DeusExLevelInfo FirstLevel()
{
 local DeusExLevelInfo L;
 
 forEach AllActors(class'DeusExLevelInfo', L)
 {
  return L;
 }
}

function Tick(float D)
{
 Super.Tick(D);
 
 if (LastDamage > 0)
 {
  LastDamage -= D;
 }
 if (LastDamage <= 0)
 {
  if (LastBuild > 0)
  {
   LastBuild -= D;
  }
  if (LastBuild <= 0 && FirstPlayer().Energy < 100)
  {
   LastBuild = 0.2;
   FirstPlayer().Energy += 1;
   //BroadcastMessage("ADD EN");
  }
 }
}

function StartChallengeMode(DeusExPlayer P)
{
 local inventory anItem;
 local inventory nextItem;
 
 if (DeusExRootWindow(P.rootWindow) != None)
  DeusExRootWindow(P.rootWindow).ClearWindowStack();
  
 P.flagBase.SetBool('PlayerTraveling', True, True, 0);
 
 P.SaveSkillPoints();
 P.DeleteSaveGameFiles();

 P.bStartingNewGame = True;
 
 if (P.AugmentationSystem != None)
 {
  P.AugmentationSystem.ResetAugmentations();
  P.AugmentationSystem.Destroy();
  P.AugmentationSystem = None;
 }

 P.FirstImage = None;
 
 if (DeusExRootWindow(P.rootWindow) != None)
  DeusExRootWindow(P.rootWindow).ResetFlags();
 
 if (P.KeyRing != None)
 {
  P.KeyRing.RemoveAllKeys();

   if ((P.Role == ROLE_Authority) && (P.Level.NetMode != NM_Standalone))
   {
    P.KeyRing.ClientRemoveAllKeys();
   }

  P.KeyRing = None;
 }
 
	// clear the notes and the goals
	P.DeleteAllNotes();
	P.DeleteAllGoals();

	// Nuke the history
	P.ResetConversationHistory();

	// Other defaults
	//P.Credits = P.Default.Credits;
	P.Energy  = P.Default.Energy;
	P.SkillPointsTotal = P.Default.SkillPointsTotal;
	P.SkillPointsAvail = P.Default.SkillPointsAvail;

	P.SetInHandPending(None);
	P.SetInHand(None);

	P.bInHandTransition = False;

	P.RestoreAllHealth();
	P.ClearLog();

	// Reset save count/time
	P.saveCount = 0;
	P.saveTime  = 0.0;

	// Reinitialize all subsystems we've just nuked
	P.InitializeSubSystems();

 if (P.strstartMap == "")
		P.Level.Game.SendPlayer(P, "01_NYC_UNATCOIsland");
	else
		P.Level.Game.SendPlayer(P, P.strstartMap);
}

defaultproperties
{
}
